@echo off
	set OPENSSL_CONF=c:\OpenSSL-Win32\bin\openssl.cfg
	echo.
	echo GENERATING PRIVATE KEY...
	echo ==========================================
	"C:\OpenSSL-Win32\bin\openssl" genrsa -des3 -out private.pem 2048

	IF EXIST private.pem (
   		 echo.
    		echo GENERATING NEW CSR...
   		echo ==========================================
  		 "C:\OpenSSL-Win32\bin\openssl" req -new -key private.pem -out certfile.csr
  		 IF EXIST certfile.csr (
			echo.
    			echo ==========================================
    			echo GENERATING SELF SIGN CERTIFICATE...
    			"C:\OpenSSL-Win32\bin\openssl" x509 -req -days 365 -in certfile.csr -signkey private.pem -out cert.crt 
			IF EXIST cert.crt (
				echo.
    				echo ==========================================				
				echo GENERATING PKCS8 PRIVATE KEY...
				"C:\OpenSSL-Win32\bin\openssl" pkcs8 -topk8 -inform PEM -outform DER -in private.pem -out private.der -nocrypt
    				DEL certfile.csr
				echo.
    				echo ==========================================
    				echo FINISH. Certificate created...
    				echo ==========================================
			) ELSE (
				echo.
				echo  FAILED TO CREATE CERTIFICATE...ABORTING
    				echo ==========================================
			)
    		) ELSE (
			echo.
    			echo ERROR in GENERATING SELF SIGN CERTIFICATE...ABORTING 
			echo ==========================================
    		)
	) ELSE (
   		echo.
   		echo ERROR in GENERATING PRIVATE KEY...ABORTING
   		echo ==========================================
	)
echo.
pause



